/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.expression;

import com.google.common.base.Splitter;
import com.google.common.primitives.Ints;
import ivorius.ivtoolkit.blocks.BlockStates;
import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.utils.IntegerRanges;
import ivorius.reccomplex.utils.algebra.BoolFunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.RCBoolAlgebra;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Pair;

public class BlockExpression
extends BoolFunctionExpressionCache<IBlockState, Object> {
    public static final String BLOCK_ID_PREFIX = "id=";
    public static final String DOMAIN_PREFIX = "domain=";
    public static final String METADATA_PREFIX = "metadata=";
    public static final String PROPERTY_PREFIX = "property[";
    public final MCRegistry registry;

    public BlockExpression(MCRegistry registry) {
        super(RCBoolAlgebra.algebra(), true, TextFormatting.GREEN + "Any Block");
        this.registry = registry;
        this.addTypes(new IDVariableType(BLOCK_ID_PREFIX, "", registry), t -> t.alias("", ""));
        this.addTypes(new DomainVariableType(DOMAIN_PREFIX, "", registry), new Function[0]);
        this.addTypes(new MetadataVariableType(METADATA_PREFIX, ""), t -> t.alias("#", ""));
        this.addTypes(new PropertyVariableType(PROPERTY_PREFIX, ""), t -> t.alias("$[", ""));
    }

    public static String of(MCRegistry registry, Block block) {
        return registry.idFromBlock(block).toString();
    }

    public static String of(MCRegistry registry, Block block, Integer metadata) {
        return String.format("%s & %s%d", registry.idFromBlock(block), METADATA_PREFIX, metadata);
    }

    public static String of(MCRegistry registry, Block block, IntegerRange range) {
        return String.format("%s & %s%d-%d", registry.idFromBlock(block), METADATA_PREFIX, range.min, range.max);
    }

    public class PropertyVariableType
    extends FunctionExpressionCache.VariableType<Boolean, IBlockState, Object> {
        public PropertyVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        public Pair<String, String> parsePropery(String var) {
            int close = var.indexOf("]=");
            return close >= 0 ? Pair.of((Object)var.substring(0, close), (Object)var.substring(close + 2)) : null;
        }

        @Override
        public Function<SupplierCache<IBlockState>, Boolean> parse(String var) {
            Pair<String, String> pair = this.parsePropery(var);
            return state -> pair != null && this.getProperty(((IBlockState)state.get()).func_177230_c(), (String)pair.getLeft()).filter(property -> property.func_185929_b((String)pair.getRight()).orNull() == ((IBlockState)state.get()).func_177229_b(property)).isPresent();
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            Pair<String, String> pair = this.parsePropery(var);
            if (pair != null) {
                return Block.field_149771_c.func_148742_b().stream().map(arg_0 -> ((RegistryNamespacedDefaultedByKey)Block.field_149771_c).func_82594_a(arg_0)).anyMatch(block -> this.hasPropertyEntry(pair, (Block)block)) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
            }
            return FunctionExpressionCache.Validity.ERROR;
        }

        protected boolean hasPropertyEntry(Pair<String, String> pair, Block block) {
            return this.getProperty(block, (String)pair.getLeft()).filter(property -> property.func_185929_b((String)pair.getRight()).isPresent()).isPresent();
        }

        private Optional<IProperty<?>> getProperty(Block block, String key) {
            return block.func_176223_P().func_177228_b().keySet().stream().filter(property -> property.func_177701_a().equals(key)).findFirst();
        }

        @Override
        protected String getVarRepresentation(String var, Object o) {
            Pair<String, String> pair = this.parsePropery(var);
            return pair != null ? this.getRepresentation(this.keyValidity((String)pair.getLeft(), o)) + (String)pair.getLeft() + TextFormatting.BLUE + "]=" + this.getRepresentation(this.validity(var, o)) + (String)pair.getRight() : super.getVarRepresentation(var, o);
        }

        protected FunctionExpressionCache.Validity keyValidity(String var, Object o) {
            return Block.field_149771_c.func_148742_b().stream().map(arg_0 -> ((RegistryNamespacedDefaultedByKey)Block.field_149771_c).func_82594_a(arg_0)).anyMatch(block -> this.getProperty((Block)block, var).isPresent()) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
        }
    }

    public class MetadataVariableType
    extends FunctionExpressionCache.VariableType<Boolean, IBlockState, Object> {
        public MetadataVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        public IntegerRange parseMetadataExp(String var) {
            if (var.contains("-")) {
                List split = Splitter.on((char)'-').splitToList((CharSequence)var);
                if (split.size() != 2) {
                    return null;
                }
                Integer left = this.parseMetadata((String)split.get(0));
                Integer right = this.parseMetadata((String)split.get(1));
                return left != null && right != null ? IntegerRanges.from(left, right) : null;
            }
            Integer meta = this.parseMetadata(var);
            return meta != null ? new IntegerRange(meta.intValue(), meta.intValue()) : null;
        }

        public Integer parseMetadata(String var) {
            Integer integer = Ints.tryParse((String)var);
            return integer != null && integer >= 0 && integer < 16 ? integer : null;
        }

        @Override
        public Function<SupplierCache<IBlockState>, Boolean> parse(String var) {
            IntegerRange range = this.parseMetadataExp(var);
            return s -> {
                int metadata = BlockStates.toMetadata((IBlockState)((IBlockState)s.get()));
                return range != null && metadata >= range.min && metadata <= range.max;
            };
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            return this.parseMetadataExp(var) != null ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.ERROR;
        }
    }

    public class DomainVariableType
    extends FunctionExpressionCache.VariableType<Boolean, IBlockState, Object> {
        public MCRegistry registry;

        public DomainVariableType(String prefix, String suffix, MCRegistry registry) {
            super(prefix, suffix);
            this.registry = registry;
        }

        @Override
        public Function<SupplierCache<IBlockState>, Boolean> parse(String var) {
            return s -> this.registry.idFromBlock(((IBlockState)s.get()).func_177230_c()).func_110624_b().equals(var);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            if (Loader.instance().getIndexedModList().keySet().contains(var)) {
                return FunctionExpressionCache.Validity.KNOWN;
            }
            return FunctionExpressionCache.Validity.UNKNOWN;
        }
    }

    public class IDVariableType
    extends FunctionExpressionCache.VariableType<Boolean, IBlockState, Object> {
        public MCRegistry registry;

        public IDVariableType(String prefix, String suffix, MCRegistry registry) {
            super(prefix, suffix);
            this.registry = registry;
        }

        @Override
        public Function<SupplierCache<IBlockState>, Boolean> parse(String var) {
            Block block = this.registry.blockFromID(new ResourceLocation(var));
            return s -> ((IBlockState)s.get()).func_177230_c() == block;
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            ResourceLocation location = new ResourceLocation(var);
            return this.registry.blockFromID(location) != Blocks.field_150350_a || location.equals(Block.field_149771_c.func_177774_c((Object)Blocks.field_150350_a)) ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.UNKNOWN;
        }
    }
}

